import pandas as pd  
import pickle 
from decision_company import read_csv_file, filter_by_condition, fetch_column

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Assuming you have a DataFrame named 'credit_customers' with a column 'age'  
mode_age_count = len(filter_by_condition(credit_customers, fetch_column(credit_customers, 'age') == 27))  
median_age_count = len(filter_by_condition(credit_customers, fetch_column(credit_customers, 'age') == 33))  
  
difference = mode_age_count - median_age_count  
print(f"There are {difference} more customers with the mode age of 27 years than the median age of 33 years.")
pickle.dump(difference,open("./ref_result/difference.pkl","wb"))